<?php
/*
Plugin Name: Limit Posts
Plugin URI: http://labitacora.net/comunBlog/limit-post.phps
Description: Limits the displayed text length on the index page entries and generates a link to a page to read the full content if its bigger than the selected maximum length.
Usage: the_content_limit($max_charaters, $more_link)
Version: 1.1
Author: Alfonso Sánchez-Paus Díaz y Julián Simón de Castro
Author URI: http://labitacora.net/
License: GPL
Download URL: http://labitacora.net/comunBlog/limit-post.phps
Make:
    In file index.php
    replace the_content()
    with the_content_limit(1000, "more")
*/

if(!function_exists("the_content_limit")) :

function the_content_limit($max_char, $link, $content = null, $more_link_text = '(more...)', $with_link = true,$stripteaser = 0, $more_file = '') {
	
	if(!is_null($content)) :
	    $content = get_the_content($more_link_text, $stripteaser, $more_file);
	endif;
	
    $content = str_replace(']]>', ']]&gt;', $content);
    $content = strip_tags($content);

   if (strlen($_GET['p']) > 0) {
      echo $content;
	  
	  if($with_link) {
      echo "<div class='content-read-more'><a href='";
	  echo $link;
      echo "'>"."(more...)</a>";
      echo "</div>";
	  
	  }
	  else { echo $more_link_text; }
   }
   else if ((strlen($content)>$max_char) && ($espacio = strpos($content, " ", $max_char ))) {
        $content = substr($content, 0, $espacio);
        $content = $content;
        echo $content;
		if($with_link) {
	    echo "<div class='content-read-more'><a href='";
		echo $link;
        echo "'>".$more_link_text."</a>";
        echo "</div>";
		}
	  else { echo $more_link_text; }
   }
   else {
      echo $content;
   }
}

endif;

?>
